set sql_safe_updates=0;

SET @dtproviderId=(SELECT id FROM dtprovider WHERE `dataProviderName`='CONSOLIDATE_ATTENDANCE_MISSED_BY_FACULTY_DL');

UPDATE `sql_dtprovider` SET `sqlQuery`='SELECT 
    T1.facultyId AS USER_ID
FROM
    `course_coverage_plan` T1
        LEFT JOIN
     program_batch_course_param prm on prm.courseVarientId = T1.courseVariantId
        LEFT JOIN
    `prog_batch_period_config` T2 ON T2.id = prm.progBatchPeriodConfigId        
WHERE
    T1.studentCourseAttendanceId IS NULL
 		AND T1.academyLocationId in (namedParams)
        AND T1.sessionDate <= DATE(NOW())
        AND T2.isCurrentPeriodOfProgram = TRUE
        AND T1.whetherDeleted = false
GROUP BY T1.facultyId' WHERE `dataProviderId`=@dtproviderId;

SET @dtproviderId=(SELECT id FROM dtprovider WHERE `dataProviderName`='CONSOLIDATE_ATTENDANCE_MISSED_BY_FACULTY_RCPNT');

UPDATE `sql_dtprovider` SET `sqlQuery`="SELECT 
    T1.facultyId AS ID,
    T1.id AS PLAN_ID,
	DATE_FORMAT(T1.sessionDate, '%d-%m-%Y') AS SESSION_DATE,
    T2.courseVariantDescription AS COURSE_VARIANT_DESCRIPTION,
    T3.displayName AS ACADEMY_NAME,
    T5.firstName AS FIRST_NAME,
    T5.lastName AS LAST_NAME,
	T5.emailId AS EMAIL_ID,
    T5.mobileNumber AS MOBILE_NO,
    T5.mobileCountryCode AS MOBILE_CODE,
    T6.salutationName AS SALUTATION_NAME,
    DATE_FORMAT(T1.slotFrom, '%h:%i %p') AS SLOT_FROM,
    DATE_FORMAT(T1.slotTo, '%h:%i %p') AS SLOT_TO,
	date_format(DATE(NOW()), '%d-%m-%Y') as TODAY_DATE
FROM
    course_coverage_plan T1
        LEFT JOIN
        program_batch_course_param prm on prm.courseVarientId = T1.courseVariantId
        LEFT JOIN
    `prog_batch_period_config` per ON per.id = prm.progBatchPeriodConfigId        
        LEFT JOIN
    course_variants T2 ON T2.id = T1.courseVariantId
        LEFT JOIN
    academy_location T3 ON T3.id = T1.academyLocationId
        LEFT JOIN
    staffs T4 ON T4.userId = T1.facultyId
        LEFT JOIN
    persons T5 ON T5.id = T4.personId
   	    LEFT join
    salutations T6 ON T6.id = T5.salutationId
WHERE
    T1.facultyId IN (namedParams)
    AND per.isCurrentPeriodOfProgram = TRUE
    AND T1.studentCourseAttendanceId is null
    AND T1.whetherDeleted = false
	AND T1.sessionDate <= DATE(NOW())" WHERE `dataProviderId`=@dtproviderId;
        
set sql_safe_updates=1;